********************************************************************************
****************************** HES APC Patient *********************************
******************************* Chapter 8.3 ************************************


*     Setting globals
global hesapc "My file path:\...\CPRD data _risks\HES APC\Type2_delivery\Results\Aurum_linked\Final\"
global working "My file path:\...\Stata files\Working\"


***************** Step 1: Import HES APC Patient file **************************
import delimited "$hesapc\hes_patient.txt", bindquote(nobind) stripquote(no) stringcols(_all)




***************** Step 2: Look at n_patid_hes **********************************
*     We want to drop those with too many HES ID's (>20)
codebook n_patid_hes

gen hesid = real( n_patid_hes)
drop n_patid_hes
rename hesid n_patid_hes

drop if n_patid_hes >20




***************** Step 3: Look at Quality of matching **************************
*     Look at quality of matching between AURUM and HES (perhaps drop rank>1)
codebook match_rank

keep if match_rank=="1"

*     Keep list of acceptable patid's
keep patid

*     Save list
save "$working\HESlinked_acceptable_patients.dta"

